/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.lpar;

import com.ibm.hsc.auiml.databeans.lpar.HSCDMemoryBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.ConfirmationDialog;
import com.ibm.hsc.websm.cec.MemRecoverDialog;
import com.ibm.hsc.websm.cec.ResRecoverDialog;
import com.ibm.ui.framework.ValueDescriptor;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.Hashtable;
import java.util.Vector;

public class HSCDMemoryBeanExt
extends HSCDMemoryBean {
    public static final String ERR_NO_MEM_MOVE_DEST = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_MEM_MOVE_DEST", "HMCERRV3DLPAR008: No destination LPAR is selected for memory move operation.");
    public static final String ERR_NO_MEM_SEL = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_MEM_SEL", "HMCERRV3DLPAR009: The amount of memory selected for DLPAR operation is equal to or less than 0 MB.");
    public static final String GB_LABEL = HSCResourceBundleUtil.getMessage("DLPARBundle", "GB_LABEL", "GB");
    public static final String MB_LABEL = HSCResourceBundleUtil.getMessage("DLPARBundle", "MB_LABEL", "MB");
    public static final String CONFIRM_MSG = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_DLPAR_MEM_WARNING", "This operation could take longer than {0} minutes, although this will vary by the workload on the logical partition.\nIf you would like to limit the time within which this operation can complete, please click No and select a Timeout setting greater than 0, otherwise click Yes.", new String[]{"7"});
    public static final String CONFIRM_TITLE = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_MEM_DLPAR_CONFIRM", "Memory Dynamic Logical Partitioning Confirmation");
    private int mLMBSize = 256;
    private int mLMBInGB = 4;

    public HSCDMemoryBeanExt() {
        this.mMainPanelName = "MemMainPanel";
        this.mAddPanelName = "MemAddPanel";
        this.mRemovePanelName = "MemRemovePanel";
        this.mMovePanelName = "MemMovePanel";
        this.mTaskGroupName = "MemTaskGroup";
        this.mAddButtonName = "MemAddButton";
        this.mRemoveButtonName = "MemRemoveButton";
        this.mMoveButtonName = "MemMoveButton";
        this.mAuimlClassName = "com.ibm.hsc.auiml.databeans.lpar.DMemory";
        this.mMoveDestName = this.mMovePanelName + ".destList";
    }

    public void load() {
        this.loadBackendData();
        this.m_dRemoveGB = 0.0;
        this.m_dRemoveMB = 0.0;
        this.m_dAddGB = 0.0;
        this.m_dAddMB = 0.0;
        this.m_dMoveGB = 0.0;
        this.m_dMoveMB = 0.0;
        this.m_dDetail = 0.0;
        this.m_cdDetail = new ValueDescriptor[0];
        this.m_cdTimeout = new ValueDescriptor[0];
        this.m_dTimeout = 0.0;
        this.m_sDetailLevel = "";
        this.m_cdDetailLevel = new ValueDescriptor[0];
    }

    private String getMemDataStr(int n) {
        return "" + n / this.mLMBInGB + " " + GB_LABEL + " " + n % this.mLMBInGB * this.mLMBSize + " " + MB_LABEL + " ";
    }

    private void loadBackendData() {
        try {
            Hashtable hashtable = this.loadDataFromServer("getDLPARMemoryData");
            if (hashtable == null) {
                return;
            }
            int n = (Integer)hashtable.get("freeMems");
            int n2 = (Integer)hashtable.get("maxMems");
            int n3 = (Integer)hashtable.get("minMems");
            int n4 = (Integer)hashtable.get("allocMems");
            if (n4 <= n3) {
                this.mDisableMove = true;
                this.mDisableRemove = true;
            }
            if (n4 == n2 || n == 0) {
                this.mDisableAdd = true;
            }
            this.mRemoveNum = n4 - n3;
            if (this.mRemoveNum < 0) {
                this.mRemoveNum = 0;
            }
            this.mAddNum = n2 - n4;
            if (this.mAddNum > n) {
                this.mAddNum = n;
            }
            if (this.mAddNum < 0) {
                this.mAddNum = 0;
            }
            this.mLMBSize = (Integer)hashtable.get("LMBSize");
            this.mLMBInGB = 1024 / this.mLMBSize;
            this.setFreeMem(this.getMemDataStr(n));
            this.setMaxSourceUsage(this.getMemDataStr(n2));
            this.setSourceUsage(this.getMemDataStr(n4));
            this.m_cdMoveDest = this.initMoveToData(hashtable);
            if (IDebug.enabled) {
                System.out.println("m_cdMoveDest.length: " + this.m_cdMoveDest.length);
            }
            if (this.m_cdMoveDest.length == 0) {
                this.setMoveDestUsage("");
                this.setMoveMaxDest("");
            }
            this.mRecoverData = this.buildRecoverData("getMemRecoverInfo");
        }
        catch (Throwable throwable) {
            this.mLoadException = throwable;
            this.handleException(throwable);
        }
    }

    public void destChangedTo(int n) {
        if (IDebug.enabled) {
            System.out.println("inside memory destChangeTo");
        }
        int n2 = 0;
        if (this.m_cdMoveDest.length > 0) {
            int n3 = (Integer)this.mAllNums.elementAt(n);
            this.setMoveDestUsage(this.getMemDataStr(n3));
            int n4 = (Integer)this.mMaxNums.elementAt(n);
            this.setMoveMaxDest(this.getMemDataStr(n4));
            this.setMoveDest((String)this.mUsrNames.elementAt(n));
            n2 = n4 - n3;
            if (this.mRemoveNum < n2) {
                n2 = this.mRemoveNum;
            }
        }
        this.setMaxVal(this.mMovePanelName, n2);
    }

    protected boolean saveChanges() throws Exception {
        int n;
        int n2;
        String[] stringArray = this.getTaskGroupSelection();
        String string = null;
        String string2 = "moveMem";
        int n3 = 3;
        Integer n4 = null;
        if (stringArray[0].equals(this.mAddButtonName)) {
            n4 = new Integer((int)(this.getAddGB() * (double)this.mLMBInGB + this.getAddMB() / (double)this.mLMBSize));
            if (n4 > this.mAddNum) {
                String string3 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_MEM_MAX_ADD", "HMCERRV3DLPAR010: Try to add {0} MB memery. It is larger than max allowed value {1}.", new String[]{"" + (int)(this.getAddGB() * 1024.0 + this.getAddMB()), "" + this.mAddNum * this.mLMBSize});
                this.showInfo(string3, null, null);
                return false;
            }
            string2 = "addMem";
        } else if (stringArray[0].equals(this.mRemoveButtonName)) {
            n4 = new Integer((int)(this.getRemoveGB() * (double)this.mLMBInGB + this.getRemoveMB() / (double)this.mLMBSize));
            if (n4 > this.mRemoveNum) {
                String string4 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_MEM_MAX_REMOVE", "HMCERRV3DLPAR011: Try to remove {0} MB memery. It is larger than max allowed value {1}.", new String[]{"" + (int)(this.getRemoveGB() * 1024.0 + this.getRemoveMB()), "" + this.mRemoveNum * this.mLMBSize});
                this.showInfo(string4, null, null);
                return false;
            }
            string2 = "removeMem";
        } else if (stringArray[0].equals(this.mMoveButtonName)) {
            n4 = new Integer((int)(this.getMoveGB() * (double)this.mLMBInGB + this.getMoveMB() / (double)this.mLMBSize));
            ++n3;
            string = this.getMoveDest();
            if (string == null) {
                this.showInfo(ERR_NO_MEM_MOVE_DEST, null, null);
                return false;
            }
            if (IDebug.enabled) {
                System.out.println("num: " + n4);
            }
            n2 = this.mUsrNames.indexOf(string);
            int s = (Integer)this.mAllNums.elementAt(n2);
            int objectArray = (Integer)this.mMaxNums.elementAt(n2);
            n = objectArray - s;
            if (n > this.mRemoveNum) {
                n = this.mRemoveNum;
            }
            if (IDebug.enabled) {
                System.out.println("all: " + s + " max: " + objectArray);
            }
            if (n4 > n) {
                String string3 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_MEM_MAX_MOVE", "HMCERRV3DLPAR012: Try to move {0} MB memery. It is larger than max allowed value {1}.", new String[]{"" + (int)(this.getMoveGB() * 1024.0 + this.getMoveMB()), "" + n * this.mLMBSize});
                this.showInfo(string3, null, null);
                return false;
            }
            string = (String)this.mIntNames.elementAt(this.mUsrNames.indexOf(string));
        } else {
            return false;
        }
        if (n4 <= 0) {
            this.showInfo(ERR_NO_MEM_SEL, null, null);
            return false;
        }
        n2 = (int)this.getTimeout();
        short s = (short)this.getDetail();
        Object[] objectArray = new Object[n3];
        n = 0;
        objectArray[n++] = n4;
        if (string != null) {
            objectArray[n++] = string;
        }
        objectArray[n++] = new Integer(n2);
        objectArray[n++] = new Short(s);
        if (n4 > 60 && n2 == 0) {
            this.createConfirmDialog(string2, objectArray, s <= 0);
        } else {
            this.saveDataToServer(string2, objectArray, s <= 0);
        }
        return true;
    }

    protected void createConfirmDialog(String string, Object[] objectArray, boolean bl) {
        Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
        vector.add(this.mContainer);
        ConfirmationDialog.showDialog(vector, CONFIRM_MSG, CONFIRM_TITLE, HSCResourceBundleUtil.getMessage("HSCCommonBundle", "YES", "YES"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO", "NO"), "com.ibm.hsc.auiml.databeans.lpar.HSCDLPARConfirm", new Object[]{null, this, objectArray, string, new Boolean(bl)}, "", new Object[0]);
    }

    public void setDynamicValues() {
        super.setDynamicValues();
        String string = this.mUsrTaskMgr.getCaptionText(this.mMainPanelName);
        this.mUsrTaskMgr.setCaptionText(this.mMainPanelName, string + " " + this.mUserDefinedName);
        this.setMaxVal(this.mRemovePanelName, this.mRemoveNum);
        this.setMaxVal(this.mAddPanelName, this.mAddNum);
        this.mUsrTaskMgr.setAttribute(this.mRemovePanelName + ".mbSpinner", 30, "" + this.mLMBSize);
        this.mUsrTaskMgr.setAttribute(this.mAddPanelName + ".mbSpinner", 30, "" + this.mLMBSize);
        this.mUsrTaskMgr.setAttribute(this.mMovePanelName + ".mbSpinner", 30, "" + this.mLMBSize);
        this.destChangedTo(0);
        if (this.mRecoverData == null) {
            this.mUsrTaskMgr.setEnabled("MemInfoBtn", false);
        }
        this.mUsrTaskMgr.refreshAllElements();
    }

    private void setMaxVal(String string, int n) {
        int n2 = n / this.mLMBInGB;
        int n3 = 1024 - this.mLMBSize;
        if (n2 == 0) {
            n3 = n * this.mLMBSize;
        }
        this.mUsrTaskMgr.setAttribute(string + ".mbSpinner", 29, "" + n3);
    }

    public ResRecoverDialog getRecoverDialogInst() {
        return MemRecoverDialog.getInstance();
    }
}

